<?php if(isset($pageConfigs)): ?>
    <?php echo Helper::updatePageConfig($pageConfigs); ?>

<?php endif; ?>

<!DOCTYPE html>
<?php
    $configData = Helper::applClasses();
?>
<html
    lang="<?php if(session()->has('locale')): ?> <?php echo e(session()->get('locale')); ?><?php else: ?><?php echo e($configData['defaultLanguage']); ?> <?php endif; ?>"
    data-textdirection="<?php echo e(env('MIX_CONTENT_DIRECTION') === 'rtl' ? 'rtl' : 'ltr'); ?>"
    class="<?php echo e($configData['theme'] === 'light' ? '' : $configData['layoutTheme']); ?>">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width,initial-scale=1.0">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <meta property="og:url" content="http://promolider.xyz/" />
    <meta property="og:type" content="article" />
    <meta property="og:title" content="When Great Minds Don’t Think Alike" />
    <meta property="og:description" content="How much does culture influence creative thinking?" />
    <meta property="og:image"
        content="http://static01.nyt.com/images/2015/02/19/arts/international/19iht-btnumbers19A/19iht-btnumbers19A-facebookJumbo-v2.jpg" />

    <title><?php echo $__env->yieldContent('title'); ?> - Promolider</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css">
    <link rel="shortcut icon" type="image/x-icon" href="<?php echo e(asset('images/logo/favicon_navidad (1).ico')); ?>">
    
    <?php echo $__env->make('panels/styles', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    
    <?php echo $__env->make('panels/styles', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <script type="text/javascript">
        function callbackThen(response) {
            // read HTTP status
            console.log(response.status);

            // read Promise object
            response.json().then(function(data) {
                console.log(data);
            });
        }

        function callbackCatch(error) {
            console.error('Error:', error)
        }
    </script>

    <?php echo htmlScriptTagJsApi(); ?>

</head>

<body
    class="vertical-layout vertical-menu-modern <?php echo e($configData['blankPageClass']); ?> <?php echo e($configData['bodyClass']); ?> <?php echo e($configData['theme'] === 'dark' ? 'dark-layout' : 'light'); ?>

    data-menu="
    vertical-menu-modern data-layout="<?php echo e($configData['theme'] === 'light' ? '' : $configData['layoutTheme']); ?>"
    style="<?php echo e($configData['bodyStyle']); ?>" data-framework="laravel" data-asset-path="<?php echo e(asset('/')); ?>">

    <!-- BEGIN: Content-->
    <div class="app-content content <?php echo e($configData['pageClass']); ?>">
        <div class="content-wrapper <?php echo e($configData['layoutWidth'] === 'boxed' ? 'container p-0' : ''); ?>">
            <div id="app" class="content-body">

                
                <?php echo $__env->yieldContent('content'); ?>

            </div>
        </div>
    </div>
    <!-- End: Content-->

    
    <?php echo $__env->make('panels/scripts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <script type="text/javascript">
        $(window).on('load', function() {
            if (feather) {
                feather.replace({
                    width: 14,
                    height: 14
                });
            }
        })
    </script>
</body>

</html>
<?php /**PATH /home/promolider/public_html/crm/resources/views/layouts/fullLayoutMaster.blade.php ENDPATH**/ ?>