import axios from 'axios';
import moment from 'moment';
import Vue from 'vue';
import ElementUI from 'element-ui';
import PerfectScrollbar from 'vue2-perfect-scrollbar';
import Vue2OrgTree from 'vue2-org-tree';
import lang from 'element-ui/lib/locale/lang/es';
import locale from 'element-ui/lib/locale';
locale.use(lang);
Vue.use(ElementUI);
Vue.use(PerfectScrollbar);
Vue.use(Vue2OrgTree);

require('./bootstrap');

window.Vue = require('vue').default;

Vue.filter('formatDate', function (value) {
  if (value) {
    return moment(value).add(1, 'day').format('LLL');
  }
});
Vue.prototype.can = function (value) {
  return window.Laravel.jsPermissions.permissions.includes(value);
};
Vue.component('roles', require('./components/Roles').default);
Vue.component('course-index', require('./components/course/Courses').default);
Vue.component('courses-table', require('./components/course/coursesTable').default);
Vue.component('marketplace-table', require('./components/marketplace/MarketplaceTable').default);
Vue.component('dynamic-class', require('./components/dinamics/view/DinamicClass').default);
Vue.component(
  'courses-table-verification',
  require('./components/course/verification/coursesVerification').default
);
Vue.component('course-create', require('./components/course/CoursesCreate').default);
Vue.component('course-create-exam', require('./components/course/exam/createExam').default);
Vue.component('module-create-exam', require('./components/course/exam/module/createExam').default);
Vue.component('lesson-create-exam', require('./components/course/exam/lesson/createExam').default);
Vue.component('course-edit-exam', require('./components/course/exam/editExam').default);
Vue.component('course-edit-game-1', require('./components/course/game/editGame1').default);
Vue.component('course-edit-game-2', require('./components/course/game/editGame2').default);
Vue.component('course-edit-game-3', require('./components/course/game/editGame3').default);
Vue.component('course-edit-game-4', require('./components/course/game/editGame4').default);
Vue.component('course-edit-game-5', require('./components/course/game/editGame5').default);
Vue.component('course-edit-game-6', require('./components/course/game/editGame6').default);
Vue.component('create-item', require('./components/course/game/item/create').default);
Vue.component('course-game-item', require('./components/course/game/item/item').default);
Vue.component('course-gamification', require('./components/course/gamification/index').default);
Vue.component(
  'module-gamification',
  require('./components/course/gamification/indexModule').default
);
Vue.component(
  'lesson-gamification',
  require('./components/course/gamification/indexLesson').default
);
Vue.component(
  'course-certificate-config',
  require('./components/course/certificate/configure').default
);
Vue.component(
  'course-exam-question-item',
  require('./components/course/exam/examCuestion').default
);
Vue.component('rate-exam', require('./components/course/exam/rate').default);
Vue.component(
  'course-exam-question-details',
  require('./components/course/exam/detailQuestion').default
);
Vue.component('course-edit', require('./components/course/CoursesEdit').default);
Vue.component(
  'user-level-table',
  require('./components/gamification/user-levels/userLevelTable').default
);
Vue.component('badges-table', require('./components/gamification/badges/badgesTable').default);
Vue.component(
  'badges-user-view',
  require('./components/gamification/badges/user-view-badges').default
);
Vue.component('notification-view', require('./components/notification/notification').default);
Vue.component(
  'course-module-list',
  require('./components/course/modules/CourseModuleList').default
);
Vue.component('course-add-module', require('./components/course/modules/addModule').default);
Vue.component('class-edit', require('./components/course/modules/classes/editClass').default);
Vue.component('class-view', require('./components/course/modules/classes/viewClass').default);
Vue.component('course-list', require('./components/course/subscriber/CourseList').default);
Vue.component('review-course', require('./components/course/verification/review.vue').default);
Vue.component('categories-table', require('./components/category/CategoriesTable.vue').default);
Vue.component('category-create', require('./components/category/CategoryCreate.vue').default);
Vue.component('setting-profile-user', require('./components/setting/ProfileUser').default);
Vue.component('setting-security-user', require('./components/setting/Security').default);
Vue.component('billing-plans-profile', require('./components/setting/Billing-Plans').default);
Vue.component('account-profile', require('./components/setting/Account-Profile.vue').default);
Vue.component('share-link-profile', require('./components/setting/ShareLink.vue').default);
Vue.component('course-request', require('./components/course/CourseRequest.vue').default);
Vue.component('chatgpt-chat', require('./components/chatgpt/Gpt.vue').default);
Vue.component('rank-bonus-progress', require('./components/RankBonusProgress.vue').default);
Vue.component('payment', require('./components/payment/Payment').default);
/** Start components Config */
Vue.component('bank', require('./components/config/bank/Bank').default);
Vue.component('advertisement', require('./components/config/advertisement/Advertisement').default);
Vue.component(
  'payment-method',
  require('./components/config/payment-method/PaymentMethod').default
);
Vue.component(
  'classroom-point-config',
  require('./components/config/classroom-point-config/ClassroomPointConfig.vue').default
);
Vue.component(
  'config-option',
  require('./components/config/config-option/ConfigOption.vue').default
);
Vue.component('users-list', require('./components/users/List').default);
Vue.component('bonus-component', require('./components/config/BonusComponent.vue').default);
Vue.component('account-type', require('./components/config/account-type/AccountType').default);
Vue.component('user-request', require('./components/users/UserRequest.vue').default);
Vue.component('role-request', require('./components/role/RoleRequest.vue').default);

/** End components Config */

// User membreship
Vue.component('binary-branch', require('./components/binary-branch/BinaryBranch').default);
Vue.component('payment-request', require('./components/payment/PaymentRequest.vue').default);
Vue.component('modal-user', require('./components/ModalUser.vue').default);
Vue.component('tree-component', require('./components/TreeComponent.vue').default);
Vue.component('adjust-leg', require('./components/AdjustLeg.vue').default);
Vue.component('user-status', require('./components/UserStatus.vue').default);
Vue.component('user-dash', require('./components/UserDash.vue').default);
Vue.component('binary-tree', require('./components/BinaryTree.vue').default);
Vue.component('points-buttons', require('./components/PointsButtons.vue').default);
Vue.component('wallet-history-user', require('./components/wallet/WalletHistoryUser.vue').default);
Vue.component(
  'wallet-history-complete',
  require('./components/wallet/WalletHistoryComplete.vue').default
);
Vue.component('wallet-my-purchase', require('./components/wallet/WalletMyPurchase.vue').default);
Vue.component('wallet-config', require('./components/wallet/ConfigWallet.vue').default);
Vue.component('wallet-my-sales', require('./components/wallet/WalletMySales.vue').default);
//Vue.component('wallet-proyeccion', require('./components/wallet/WalletProyeccion.vue').default);
Vue.component('wallet-historial', require('./components/wallet/WalletHistorial.vue').default);
Vue.component('users-funds', require('./components/UsersFunds.vue').default);
Vue.component('user-bonuses', require('./components/UserBonuses.vue').default);
Vue.component(
  'certificates-configurations',
  require('./components/config/certificates/certificates.vue').default
);
Vue.component('settings', require('./components/config/settings/Settings.vue').default);
Vue.component(
  'frequent-questions',
  require('./components/config/frequent-questions/FrequentQuestions.vue').default
);
Vue.component('course-form', require('./components/CourseForm.vue').default);
Vue.component('aviso', require('./components/aviso.vue').default);
const app = new Vue({
  el: '#app',
});

Vue.component('show-modules', require('./components/ShowModules').default);
