import _mergeJSXProps from "babel-helper-vue-jsx-merge-props";
export default {
  name: 'SunIcon',
  props: {
    size: {
      type: String,
      default: '24',
      validator: function validator(s) {
        return !isNaN(s) || s.length >= 2 && !isNaN(s.slice(0, s.length - 1)) && s.slice(-1) === 'x';
      }
    }
  },
  functional: true,
  render: function render(h, ctx) {
    var size = ctx.props.size.slice(-1) === 'x' ? ctx.props.size.slice(0, ctx.props.size.length - 1) + 'em' : parseInt(ctx.props.size) + 'px';
    var attrs = ctx.data.attrs || {};
    attrs.width = attrs.width || size;
    attrs.height = attrs.height || size;
    ctx.data.attrs = attrs;
    return h("svg", _mergeJSXProps([{
      attrs: {
        xmlns: "http://www.w3.org/2000/svg",
        width: "24",
        height: "24",
        viewBox: "0 0 24 24",
        fill: "none",
        stroke: "currentColor",
        "stroke-width": "2",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      },
      "class": "feather feather-sun"
    }, ctx.data]), [h("circle", {
      attrs: {
        cx: "12",
        cy: "12",
        r: "5"
      }
    }), h("line", {
      attrs: {
        x1: "12",
        y1: "1",
        x2: "12",
        y2: "3"
      }
    }), h("line", {
      attrs: {
        x1: "12",
        y1: "21",
        x2: "12",
        y2: "23"
      }
    }), h("line", {
      attrs: {
        x1: "4.22",
        y1: "4.22",
        x2: "5.64",
        y2: "5.64"
      }
    }), h("line", {
      attrs: {
        x1: "18.36",
        y1: "18.36",
        x2: "19.78",
        y2: "19.78"
      }
    }), h("line", {
      attrs: {
        x1: "1",
        y1: "12",
        x2: "3",
        y2: "12"
      }
    }), h("line", {
      attrs: {
        x1: "21",
        y1: "12",
        x2: "23",
        y2: "12"
      }
    }), h("line", {
      attrs: {
        x1: "4.22",
        y1: "19.78",
        x2: "5.64",
        y2: "18.36"
      }
    }), h("line", {
      attrs: {
        x1: "18.36",
        y1: "5.64",
        x2: "19.78",
        y2: "4.22"
      }
    })]);
  }
};