import _mergeJSXProps from "babel-helper-vue-jsx-merge-props";
export default {
  name: 'LoaderIcon',
  props: {
    size: {
      type: String,
      default: '24',
      validator: function validator(s) {
        return !isNaN(s) || s.length >= 2 && !isNaN(s.slice(0, s.length - 1)) && s.slice(-1) === 'x';
      }
    }
  },
  functional: true,
  render: function render(h, ctx) {
    var size = ctx.props.size.slice(-1) === 'x' ? ctx.props.size.slice(0, ctx.props.size.length - 1) + 'em' : parseInt(ctx.props.size) + 'px';
    var attrs = ctx.data.attrs || {};
    attrs.width = attrs.width || size;
    attrs.height = attrs.height || size;
    ctx.data.attrs = attrs;
    return h("svg", _mergeJSXProps([{
      attrs: {
        xmlns: "http://www.w3.org/2000/svg",
        width: "24",
        height: "24",
        viewBox: "0 0 24 24",
        fill: "none",
        stroke: "currentColor",
        "stroke-width": "2",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      },
      "class": "feather feather-loader"
    }, ctx.data]), [h("line", {
      attrs: {
        x1: "12",
        y1: "2",
        x2: "12",
        y2: "6"
      }
    }), h("line", {
      attrs: {
        x1: "12",
        y1: "18",
        x2: "12",
        y2: "22"
      }
    }), h("line", {
      attrs: {
        x1: "4.93",
        y1: "4.93",
        x2: "7.76",
        y2: "7.76"
      }
    }), h("line", {
      attrs: {
        x1: "16.24",
        y1: "16.24",
        x2: "19.07",
        y2: "19.07"
      }
    }), h("line", {
      attrs: {
        x1: "2",
        y1: "12",
        x2: "6",
        y2: "12"
      }
    }), h("line", {
      attrs: {
        x1: "18",
        y1: "12",
        x2: "22",
        y2: "12"
      }
    }), h("line", {
      attrs: {
        x1: "4.93",
        y1: "19.07",
        x2: "7.76",
        y2: "16.24"
      }
    }), h("line", {
      attrs: {
        x1: "16.24",
        y1: "7.76",
        x2: "19.07",
        y2: "4.93"
      }
    })]);
  }
};