import _mergeJSXProps from "babel-helper-vue-jsx-merge-props";
export default {
  name: 'CpuIcon',
  props: {
    size: {
      type: String,
      default: '24',
      validator: function validator(s) {
        return !isNaN(s) || s.length >= 2 && !isNaN(s.slice(0, s.length - 1)) && s.slice(-1) === 'x';
      }
    }
  },
  functional: true,
  render: function render(h, ctx) {
    var size = ctx.props.size.slice(-1) === 'x' ? ctx.props.size.slice(0, ctx.props.size.length - 1) + 'em' : parseInt(ctx.props.size) + 'px';
    var attrs = ctx.data.attrs || {};
    attrs.width = attrs.width || size;
    attrs.height = attrs.height || size;
    ctx.data.attrs = attrs;
    return h("svg", _mergeJSXProps([{
      attrs: {
        xmlns: "http://www.w3.org/2000/svg",
        width: "24",
        height: "24",
        viewBox: "0 0 24 24",
        fill: "none",
        stroke: "currentColor",
        "stroke-width": "2",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      },
      "class": "feather feather-cpu"
    }, ctx.data]), [h("rect", {
      attrs: {
        x: "4",
        y: "4",
        width: "16",
        height: "16",
        rx: "2",
        ry: "2"
      }
    }), h("rect", {
      attrs: {
        x: "9",
        y: "9",
        width: "6",
        height: "6"
      }
    }), h("line", {
      attrs: {
        x1: "9",
        y1: "1",
        x2: "9",
        y2: "4"
      }
    }), h("line", {
      attrs: {
        x1: "15",
        y1: "1",
        x2: "15",
        y2: "4"
      }
    }), h("line", {
      attrs: {
        x1: "9",
        y1: "20",
        x2: "9",
        y2: "23"
      }
    }), h("line", {
      attrs: {
        x1: "15",
        y1: "20",
        x2: "15",
        y2: "23"
      }
    }), h("line", {
      attrs: {
        x1: "20",
        y1: "9",
        x2: "23",
        y2: "9"
      }
    }), h("line", {
      attrs: {
        x1: "20",
        y1: "14",
        x2: "23",
        y2: "14"
      }
    }), h("line", {
      attrs: {
        x1: "1",
        y1: "9",
        x2: "4",
        y2: "9"
      }
    }), h("line", {
      attrs: {
        x1: "1",
        y1: "14",
        x2: "4",
        y2: "14"
      }
    })]);
  }
};