import { defineComponent, ref, computed, onMounted, onBeforeUnmount, h, isVue2 } from 'vue-demi';

let unityInstanceIdentifier = 0;
function cssUnit(val) {
    return isNaN(val) ? val : val + 'px';
}
var index = defineComponent({
    name: 'UnityWebglComponent',
    props: {
        unity: {
            type: Object
        },
        width: {
            type: [String, Number],
            default: '100%'
        },
        height: {
            type: [String, Number],
            default: '100%'
        },
        tabindex: {
            type: [Number, String]
        }
    },
    setup(props) {
        const canvas = ref(null);
        unityInstanceIdentifier++;
        const canvasStyle = computed(() => {
            return {
                width: cssUnit(props.width),
                height: cssUnit(props.height)
            };
        });
        const attrs = {
            id: `unity-canvas-${unityInstanceIdentifier}`
        };
        if (props.tabindex || props.tabindex === 0) {
            attrs.tabindex = props.tabindex;
        }
        onMounted(() => {
            var _a;
            if (canvas.value) {
                (_a = props.unity) === null || _a === void 0 ? void 0 : _a.create(canvas.value);
            }
        });
        onBeforeUnmount(() => {
            var _a;
            (_a = props.unity) === null || _a === void 0 ? void 0 : _a._unsafe_unload();
        });
        return () => h('canvas', isVue2
            ? {
                ref: canvas,
                attrs,
                style: canvasStyle.value
            }
            : Object.assign({ ref: canvas, style: canvasStyle.value }, attrs));
    }
});

export { index as default };
