<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;

class RoleSeeder extends Seeder
{
    public function run()
    {
        $role1 = Role::create(['name' => 'Admin']);
        $role2 = Role::create(['name' => 'Producer']);
        $role3 = Role::create(['name' => 'Distributor']);

        //NUEVOS PERMISOS---------------------------------------------
        Permission::create(['name' => 'menu-virtual-class', 'description' => 'Course services', 'section' => 'true'])->syncRoles([$role1, $role2, $role3]); //NO MODIFICAR
        Permission::create(['name' => 'requests', 'description' => 'requests', 'section' => 'true'])->syncRoles([$role1, $role2]);
        Permission::create(['name' => 'reports', 'description' => 'reports', 'section' => 'true'])->syncRoles([$role1, $role2, $role3]);
        Permission::create(['name' => 'config', 'description' => 'config', 'section' => 'true'])->syncRoles([$role1]);
        Permission::create(['name' => 'menu-dashboard', 'description' => 'Dashboard', 'section' => 'true'])->syncRoles([$role1, $role2, $role3]); //NO MODIFICAR
        Permission::create(['name' => 'dashboard-ecommerce', 'description' => 'eCommerce', 'section' => 'true'])->syncRoles([$role1, $role2, $role3]); //NO MODIFICAR
        Permission::create(['name' => 'binary-branch', 'description' => 'Red-Binary', 'section' => 'true'])->syncRoles([$role1, $role2, $role3]); //NO MODIFICAR
        Permission::create(['name' => 'organization', 'description' => 'organization', 'section' => 'true'])->syncRoles([$role1, $role2]);
        Permission::create(['name' => 'configuration-certificates', 'description' => 'Configuration certificates', 'module' => 'config'])->syncRoles([$role1, $role2]);
        Permission::create(['name' => 'role.index', 'description' => 'Roles and Permissions', 'module' => 'config'])->syncRoles([$role1, $role2]);
        Permission::create(['name' => 'user-levels-index', 'description' => 'User Levels', 'module' => 'config'])->syncRoles([$role1, $role2]);
        Permission::create(['name' => 'action-list-role', 'description' => 'List roles', 'action' => 'role.index'])->syncRoles([$role1, $role2]);
        Permission::create(['name' => 'action-edit-role', 'description' => 'Edit roles', 'action' => 'role.index'])->syncRoles([$role1, $role2]);
        Permission::create(['name' => 'action-remove-role', 'description' => 'Remove roles', 'action' => 'role.index'])->syncRoles([$role1, $role2]);
        Permission::create(['name' => 'action-list-permissions', 'description' => 'List permissions', 'action' => 'role.index'])->syncRoles([$role1, $role2]);
        Permission::create(['name' => 'action-add-remove-permission', 'description' => 'Add and remove permissions', 'action' => 'role.index'])->syncRoles([$role1, $role2]);
        Permission::create(['name' => 'category-index', 'description' => 'categories list', 'module' => 'config'])->syncRoles([$role1, $role2]);
        Permission::create(['name' => 'category-create', 'description' => 'category create', 'module' => 'category-index'])->syncRoles([$role1, $role2]);
        Permission::create(['name' => 'category-edit', 'description' => 'category edit', 'module' => 'category-index'])->syncRoles([$role1, $role2]);
        Permission::create(['name' => 'courses.verification', 'description' => 'Verification Courses', 'module' => 'requests'])->syncRoles([$role1]);
        Permission::create(['name' => 'classroom-certificates', 'description' => 'Add Certificate', 'module' => 'menu-virtual-class'])->syncRoles([$role1, $role2]);
        Permission::create(['name' => 'courses.create', 'description' => 'Create course', 'action' => 'courses.index'])->syncRoles([$role1, $role2]);
        Permission::create(['name' => 'courses.edit', 'description' => 'Edit Courses', 'action' => 'courses.index'])->syncRoles([$role1, $role2]);
        Permission::create(['name' => 'courses.index', 'description' => 'List Courses', 'module' => 'menu-virtual-class'])->syncRoles([$role1, $role2, $role3]);
        Permission::create(['name' => 'chatgpt.index', 'description' => 'List Gpt', 'module' => 'menu-virtual-class'])->syncRoles([$role1, $role2, $role3]);
        Permission::create(['name' => 'marketplace.toggle', 'description' => 'Marketplace Course Toggle', 'module' => 'menu-virtual-class'])->syncRoles([$role1]);
        Permission::create(['name' => 'marketing.index', 'description' => 'Marketing pages creation', 'module' => 'menu-virtual-class'])->syncRoles([$role1, $role2, $role3]);
        Permission::create(['name' => 'exam-create', 'description' => 'List Exam', 'module' => 'menu-virtual-class'])->syncRoles([$role1, $role2]);
        Permission::create(['name' => 'exams.rate', 'description' => 'Rate Exam', 'module' => 'menu-virtual-class'])->syncRoles([$role1, $role2]);
        Permission::create(['name' => 'courses.subs', 'description' => 'Subscriptor Courses', 'module' => 'menu-virtual-class'])->syncRoles([$role1, $role2]);
        Permission::create(['name' => 'withdrawal_funds', 'description' => 'List Payments', 'module' => 'requests'])->syncRoles([$role1]);
        Permission::create(['name' => 'report-wallets', 'description' => 'User Funds', 'module' => 'reports'])->syncRoles([$role1, $role2, $role3]);
        Permission::create(['name' => 'report-nmywallet', 'description' => 'My Wallet', 'module' => 'reports'])->syncRoles([$role1, $role2, $role3]);
        Permission::create(['name' => 'report-purchase', 'description' => 'My Purchase', 'module' => 'reports'])->syncRoles([$role1, $role2, $role3]);
        Permission::create(['name' => 'report-sales', 'description' => 'My Sales', 'module' => 'reports'])->syncRoles([$role1, $role2, $role3]);
        Permission::create(['name' => 'report-startingBonus', 'description' => 'Starting Bonus List', 'module' => 'reports'])->syncRoles([$role1, $role2, $role3]);
        Permission::create(['name' => 'payment', 'description' => 'Payment', 'module' => 'reports'])->syncRoles([$role1]);
        Permission::create(['name' => 'report-growthBonus', 'description' => 'Growth Bonus List', 'module' => 'reports'])->syncRoles([$role1, $role2, $role3]);
        Permission::create(['name' => 'starting-bonus', 'description' => 'Starting Bonus', 'module' => 'reports'])->syncRoles([$role1, $role2, $role3]);
        Permission::create(['name' => 'growth-bonus', 'description' => 'Growth Bonus', 'module' => 'reports'])->syncRoles([$role1, $role2, $role3]);
        Permission::create(['name' => 'binarycut.index', 'description' => 'Binary Cut', 'module' => 'config'])->syncRoles([$role1, $role2]);
        Permission::create(['name' => 'advertisements', 'description' => 'Advertisements', 'module' => 'config'])->syncRoles([$role1, $role2]);
        Permission::create(['name' => 'action-add-advertisements', 'description' => 'Add', 'action' => 'advertisements'])->syncRoles([$role1, $role2]);
        Permission::create(['name' => 'action-edit-advertisements', 'description' => 'Edit', 'action' => 'advertisements'])->syncRoles([$role1, $role2]);
        Permission::create(['name' => 'action-delete-advertisements', 'description' => 'Delete', 'action' => 'advertisements'])->syncRoles([$role1, $role2]);
        Permission::create(['name' => 'action-list-advertisements', 'description' => 'List', 'action' => 'advertisements'])->syncRoles([$role1, $role2]);
        Permission::create(['name' => 'action-detail-advertisements', 'description' => 'Detail', 'action' => 'advertisements'])->syncRoles([$role1, $role2]);
        Permission::create(['name' => 'bank', 'description' => 'Bank', 'module' => 'config'])->syncRoles([$role1, $role2]);
        Permission::create(['name' => 'action-add-bank', 'description' => 'Add', 'action' => 'bank'])->syncRoles([$role1, $role2]);
        Permission::create(['name' => 'action-edit-bank', 'description' => 'Edit', 'action' => 'bank'])->syncRoles([$role1, $role2]);
        Permission::create(['name' => 'action-delete-bank', 'description' => 'Delete', 'action' => 'bank'])->syncRoles([$role1, $role2]);
        Permission::create(['name' => 'action-list-bank', 'description' => 'List', 'action' => 'bank'])->syncRoles([$role1, $role2]);
        Permission::create(['name' => 'action-detail-bank', 'description' => 'Detail', 'action' => 'bank'])->syncRoles([$role1, $role2]);
        Permission::create(['name' => 'payment-method', 'description' => 'Payment Method', 'module' => 'config'])->syncRoles([$role1, $role2]);
        Permission::create(['name' => 'action-add-payment-method', 'description' => 'Add', 'action' => 'payment-method'])->syncRoles([$role1, $role2]);
        Permission::create(['name' => 'action-edit-payment-method', 'description' => 'Edit', 'action' => 'payment-method'])->syncRoles([$role1, $role2]);
        Permission::create(['name' => 'action-delete-payment-method', 'description' => 'Delete', 'action' => 'payment-method'])->syncRoles([$role1, $role2]);
        Permission::create(['name' => 'action-list-payment-method', 'description' => 'List', 'action' => 'payment-method'])->syncRoles([$role1, $role2]);
        Permission::create(['name' => 'action-detail-payment-method', 'description' => 'Detail', 'action' => 'payment-method'])->syncRoles([$role1, $role2]);
        Permission::create(['name' => 'config-settings', 'description' => 'Settings', 'module' => 'config'])->syncRoles([$role1, $role2, $role3]);
        Permission::create(['name' => 'classroom-point-config', 'description' => 'Classroom Point Config', 'module' => 'config'])->syncRoles([$role1, $role2]);
        Permission::create(['name' => 'action-list-classroom-point-config', 'description' => 'List', 'action' => 'classroom-point-config'])->syncRoles([$role1, $role2]);
        Permission::create(['name' => 'action-edit-classroom-point-config', 'description' => 'Edit', 'action' => 'classroom-point-config'])->syncRoles([$role1, $role2]);
        Permission::create(['name' => 'account-type', 'description' => 'Account Type', 'module' => 'config'])->syncRoles([$role1, $role2, $role3]);
        Permission::create(['name' => 'menu-user-scroll', 'description' => 'User-Scroll', 'action' => 'binary-branch'])->syncRoles([$role1, $role2]);
        Permission::create(['name' => 'users-list', 'description' => 'User-Scroll-List', 'module' => 'organization'])->syncRoles([$role1]);
        Permission::create(['name' => 'new-users', 'description' => 'User Request', 'module' => 'organization'])->syncRoles([$role1]);
        Permission::create(['name' => 'courses.creation', 'description' => 'Role Request', 'module' => 'organization'])->syncRoles([$role1]);
        Permission::create(['name' => 'frequent-questions', 'description' => 'Frequent questions', 'module' => 'config'])->syncRoles([$role1, $role2]);
        Permission::create(['name' => 'option', 'description' => 'Option', 'module' => 'config'])->syncRoles([$role1, $role2]);
        Permission::create(['name' => 'action-list-option', 'description' => 'List', 'action' => 'option'])->syncRoles([$role1, $role2]);
        Permission::create(['name' => 'action-edit-option', 'description' => 'Edit', 'action' => 'option'])->syncRoles([$role1, $role2]);
        Permission::create(['name' => 'create', 'description' => 'Badges', 'module' => 'config'])->syncRoles([$role1, $role2]);
        Permission::create(['name' => 'action-list-badges', 'description' => 'List', 'action' => 'badges'])->syncRoles([$role1, $role2]);
        Permission::create(['name' => 'action-edit-badges', 'description' => 'Edit', 'action' => 'badges'])->syncRoles([$role1, $role2]);
        Permission::create(['name' => 'quiz-daily', 'description' => 'Daily', 'action' => 'quiz-daily'])->syncRoles([$role1, $role2]);
    }
}
