<?php

namespace App\Http\Controllers;

use App\Models\WalletPaymetMethod;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class WalletPaymetMethodController extends Controller
{

     public function getAll()
    {
        // Obtener todos los registros de WalletPaymentMethod
        $paymentMethods = WalletPaymetMethod::all();

        // Retornar como respuesta JSON
        return response()->json([
                'data' => $paymentMethods
            ], 200);
    }

     public function config(Request $request)
    {
       $user = auth()->user();

       if ($user) {

        $walletPaymentMethodId = $request->method_id; 

          $additionalData = [
          'email' => $request->_email,
          'account_number' => $request->account_number,
        ];
            
        $user->walletPaymentMethods()->attach($walletPaymentMethodId,$additionalData);
          return response()->json(['message' => 'Método de pago asociado correctamente.'], 200);
          
         }     
    }
     
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\WalletPaymetMethod  $walletPaymetMethod
     * @return \Illuminate\Http\Response
     */
    public function show(WalletPaymetMethod $walletPaymetMethod)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\WalletPaymetMethod  $walletPaymetMethod
     * @return \Illuminate\Http\Response
     */
    public function edit(WalletPaymetMethod $walletPaymetMethod)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\WalletPaymetMethod  $walletPaymetMethod
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, WalletPaymetMethod $walletPaymetMethod)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\WalletPaymetMethod  $walletPaymetMethod
     * @return \Illuminate\Http\Response
     */
    public function destroy(WalletPaymetMethod $walletPaymetMethod)
    {
        //
    }
}
