<?php

namespace App\Http\Controllers;

use App\Models\User;
use App\Models\Point;
use App\Models\Wallet;
use App\Models\WalletMovements;
use App\Models\Classified;
use App\Models\AccountType;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Models\AccountTypePointsMoney;
use Illuminate\Http\Resources\Json\JsonResource;
use Symfony\Component\HttpKernel\Exception\HttpException;
use App\Models\Notifications;
use App\Models\BadgeDetail;
use App\Models\Option;
use App\Models\UserClassroomPoint;
use App\Models\UserDailyQuizz;

class UserRequestController extends Controller
{
    public function __construct()
    {
        $this->middleware('can:new-users');
    }
    public function index()
    {
        $this->isAdmin(auth()->user());

        $all_user_requesting = User::with('accountType', 'paymentsClient')
            ->where('request', 1)
            ->get();

        return JsonResource::collection($all_user_requesting);
    }

    protected function isAdmin(User $user)
    {
        if ($user->id != 1) {
            throw new HttpException(422, 'Este usuario no es el administrador');
        }
    }

    // get user by id
    public function getUserById($id)
    {
        $data = User::with('sponsor')
            ->with('paymentsClient', function ($q) {
                $q->with('paymentMethod');
            })
            ->with('documentType')
            ->where('id', $id)
            ->get();

        return response()->json($data[0]);
    }

    public function updateUnverifiedRequest(Request $request)
    {
        $user = User::findOrFail($request->id);
        if (Classified::where('user_id', $user->id)->exists()) {
        } else {
            if ($request->status == 3) {
                $user->request = $request->status;
                $user->update();
            } else if ($request->status == 2) {
                $account_type = AccountType::find($user->id_account_type);
                $id_user = $user->id; // Get ID of user

                /* Crear billetera*/
                Wallet::create([
                    'user_id' => $id_user,
                    'status' => 1
                ]);

                //Se crea registro en la tabla user_daily_quizzs
                $user_daily_quizz = new UserDailyQuizz();
                $user_daily_quizz->id_user = $id_user;
                $user_daily_quizz->passed_quizz = 0;
                $user_daily_quizz->save();

                $user_referrer_position = User::select('username', 'position')
                    ->where('id', $user->id_referrer_sponsor)->first();

                //Crea un registro de la fecha de expiracion de su memebresia en la tabla ACCOUNT_TYPE_DETAIL
                app(UserController::class)->saveUserMembershipExpirationDate($id_user, $account_type->id);
                //Se crea registro en la tabla user_classroom_points
                $user_classroom_point = new UserClassroomPoint();
                $user_classroom_point->id_user = $id_user;
                $user_classroom_point->total_points = 0;
                $user_classroom_point->save();

                //algoritmo para busqueda de espacio vacio
                $position = $user_referrer_position->position == 0 ? 'user_position_left' : 'user_position_right';
                $user_above = app(UserController::class)->search_empty_position($request, $user_referrer_position, $user, $position);

                $fieldsClassifieds  = [
                    'user_id' => $id_user,
                    'id_user_sponsor' => $request["id_referrer_sponsor"],
                    'binary_sponsor' => $user_referrer_position->username,
                    'position' => $user_referrer_position->position,
                    'classification' => 16,
                    'status' => '0',
                    'authorized' => '0',
                    'user_above' => $user_above,
                ];

                $classified = Classified::create($fieldsClassifieds);

                $notification = new Notifications();
                $notification->id_generator = $id_user;
                $notification->id_receiver = $request["id_referrer_sponsor"];
                $notification->title = "Registro de Nuevo Afiliado";
                $notification->body = $user->name . ' ' . $user->last_name . ' se acaba de registrar con tu enlace';
                $notification->type = 1;
                $notification->save();

                $status = $request->status;
                $id = $user->id;
                $this->updateRequest($status, $id);
            }
        }
    }

    public function updateRequest($status, $id)
    {
        if ($status == 2) { // 
            DB::transaction(function ()  use ($status, $id) {
                $user = User::find($id);
                $user->request = $status;
                $user->save();

                $id = $user->id;
                $fullName = $user->name;
                $membersip = $user->id_account_type;

                //batch para el historial de la billetera segun corte binario
                $last_batch = Option::lastBatch();
                $last_batch = (int) $last_batch->value;

                $atm =  AccountTypePointsMoney::where('account_type_id', $user->id_account_type)->first(); //Obtengo los puntos de determiando tipo de cuenta
                $account_type = AccountType::where('id', $user->id_account_type)->first();
                $classified_user = Classified::where('user_id', $id)->first();
                $save_position_branch = $classified_user->position; //almacena la posicion del nodo anterior con respecto al actual

                $aux = false;

                if ($membersip != 5 && $membersip != 6) { //membresia basica y guest no genera puntos
                    $tmp_id = $classified_user->user_id;
                    while ($aux == false) {
                        $user_data = Classified::where('user_id', $tmp_id)->first();
                        $aux = $user_data->user_above == 'top' ? true : false;
                        $user_status = User::find($tmp_id);
                        if ($user_status->active && $user_status->qualified && $user_status->membershipActive) {
                            Point::create([
                                'user_id' => $user->id,
                                'sponsor_id' => $user_data->user_id,
                                'points' => $atm->points,
                                'side' => $save_position_branch,
                                'reason' => "Binary Team Points, "  . $fullName . " Affiliation"
                            ]);
                        } elseif ($classified_user->id_user_sponsor == $user_data->user_id) {
                            Point::create([
                                'user_id' => $user->id,
                                'sponsor_id' => $classified_user->id_user_sponsor,
                                'points' => $atm->points,
                                'side' => $save_position_branch,
                                'reason' => "Binary Team Points, "  . $fullName . " Affiliation"
                            ]);
                        }
                        $save_position_branch = $user_data->position;
                        $tmp_id = $user_data->user_above;
                    }
                }

                //bono de efectivo rapido
                if ($membersip != 5 && $membersip != 6) { //membresia basica y guest no genera bono
                    if ($user->id_referrer_sponsor != 1) {
                        $id_account_type_sponsor = User::select('id_account_type')->where('id', $user->id_referrer_sponsor)->first();
                        $fast_cash_sponsor = AccountType::select('fast_cash_bonus')->where('id', $id_account_type_sponsor->id_account_type)->first();
                        $walletParentDirect  = Wallet::where('user_id', $user->id_referrer_sponsor)->first();
                        $movement = new WalletMovements();
                        $movement->wallet_id = $walletParentDirect->id;
                        $movement->amount = $account_type->price * ($fast_cash_sponsor->fast_cash_bonus / 100);
                        $movement->type = 1;
                        $movement->batch = $last_batch;
                        $movement->bonus_type_id = 1; // bono de efectivo rapido
                        $movement->reason = 'Bono de efectivo rápido de ' . $user->username;
                        $movement->save();
                    }
                }
            });
            DB::commit();
        } else {
            DB::transaction(function ()  use ($status, $id) {
                $user = User::find($id);
                $user->request = $status;
                $user->save();
            });
        }
    }

    public function validateIfUserHasBadge($badge_id, $user_id)
    {
        $bool = BadgeDetail::where(['user_id' => $user_id, 'badge_id' => $badge_id])->exists();
        return $bool;
    }

    public function notification($id_user, $title, $body)
    {
        try {
            DB::beginTransaction();
            $notification = new Notifications();
            $notification->id_generator = $id_user;
            $notification->id_receiver =  $id_user;
            $notification->title = $title;
            $notification->body = $body;
            $notification->type = 3; # Compra de cursos
            $notification->save();
            DB::commit();
        } catch (\Throwable $th) {
            DB::rollBack();
            throw $th;
        }
    }
}
