<?php

namespace App\Http\Controllers;

use App\Helpers\ParseUrl;
use App\Models\User;
use App\Models\Classified;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use App\Services\TreeBinaryService;
use Illuminate\Http\Resources\Json\JsonResource;
use Illuminate\Http\Resources\Json\AnonymousResourceCollection;
use stdClass;

class RamaBinariaController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */

    const DEFAULT_EMPTY_NODE = [
        "id"     =>  0,
        "name"    => "Disponible",
        "photo"     => "https://cdn.icon-icons.com/icons2/1465/PNG/512/756exclamationmark_100528.png",
        "children" => [],
    ];

    public function listbinary(TreeBinaryService $treebinary): AnonymousResourceCollection
    {
        return $treebinary->listbinary();
    }


    public function getBinaryThreeData()
    {
        $user = User::select('id', 'name', 'photo')->where('id', auth()->user()->id)->get()->first();
        $childrens = $this->getDirects($user->id);
        $data = array('id' => $user->id, 'name' => $user->name, 'photo' => $user->photo, 'children' => $childrens);
        return $data;
    }


    public function getDirects($parent_id)
    {
        $rows_exists =  Classified::where(['id_user_sponsor' =>  $parent_id])->whereNotIn('user_id', array($parent_id))->exists();


        if ($rows_exists) {
            $rows = Classified::where(['id_user_sponsor' =>  $parent_id])
            ->whereNotIn('user_id', array($parent_id))
            ->join('users as u', 'classified.user_id', '=', 'u.id')
            ->select('classified.*', 'u.*', 'classified.position as classified_position')
            ->orderBy('classified.position', 'asc')
            ->get();

            $directs = [];

            foreach ($rows as $row) {
                $direct = $this->getFormatArray($row);

                array_push($directs, $direct);
            }
        } else {
            $directs = self::DEFAULT_EMPTY_NODE;
        }
        return $directs;
    }



    public function getFormatArray($data)
    {
        $directs = $this->getDirects($data->id);
        return array('id' => $data->id, 'name' => $data->name, 'photo' => ParseUrl::contacAtrrS3($data->photo), 'position'=>$data->classified_position, 'children' => $directs);
    }
}
