<?php

namespace App\Http\Controllers;

use App\Models\Payment;
use Illuminate\Http\Request;
use App\Models\UnverifiedUser;
use App\Traits\ResponseFormat;
use App\Models\UnverifiedPayment;
use Illuminate\Support\Facades\Log;
use App\Http\Controllers\PayController;
use App\Http\Resources\PaymentResource;
use App\Http\Controllers\Api\CartController;
use App\Http\Controllers\TransactionController;
use Illuminate\Http\Resources\Json\AnonymousResourceCollection;
use Symfony\Component\Console\Output\ConsoleOutput;



class PaymentController extends Controller 
{
    use ResponseFormat;
    
    public function __construct(){
        $this->middleware('can:withdrawal_funds')->only('listMyPayments');
        $this->middleware('can:payment')->only('index');
    }
    public function index()
    {
        return view('content.payment.payment');
    }

    public function List(Request $request): AnonymousResourceCollection
    {
        $payments = Payment::query()->with(['paymentMethod', 'user'])->get();
        return PaymentResource::collection($payments);
    }

    public function getAll(){
        $payments = Payment::all('created_at', 'amount', 'operation_number as reason');
        return $payments;
    }

    public function getAllUser($id)
    {
        $payments = Payment::query()->where('user_id', $id)->with(['paymentMethod', 'user'])->get();
        return PaymentResource::collection($payments);
    }

    public function listUserPayments()
    {
        $payments = Payment::paymentAuthSponsor()->with(['user.accountType', 'products'])->get();
        return PaymentResource::collection($payments);
    }

    public function listMyPayments()
    {
        return view('content.requests.payments');
    }

    public function openpayWebhookConfirm(Request $request){
        if($request->type==='verification'){
            Log::info($request);
            return response()->json(['success' => 'success'], 200);

        }

        if($request->transaction['status'] == 'completed'){
            
            //Guardar la transaccion en la tabla transactions
            app(TransactionController::class)->createTransaction($request->transaction);
            
            if(UnverifiedUser::where('openpay_order_id', $request->transaction['id'])->exists()){
                $user = UnverifiedUser::where('openpay_order_id', $request->transaction['id'])
                    ->first();
                session()->forget("body"); 
                $data2 = json_decode($user->data, true);
                session(['body' => $data2]);
                session('encrypted_pass', true);
                app(UserController::class)->Create($user->openpay_order_id);
                $user->delete();
            }else if(UnverifiedPayment::where('openpay_order_id', $request->transaction['id'])->exists()){
                $payment = UnverifiedPayment::where('openpay_order_id', $request->transaction['id'])
                    ->first();
                if($payment->product_name == 'opc'){
                    app(UserController::class)->recompraUpdate($payment->openpay_order_id);
                    $payment->delete();
                }else if($payment->product_name == 'membership'){
                    app(UserController::class)->membershipUpdate($payment->openpay_order_id, $payment->product_id);
                    $payment->delete();
                }else if($payment->product_name == 'course'){
                    $request = new Request();
                    $data = [
                        'id_course' => $payment->product_id,
                        'user_id' => $payment->user_id,
                        'type_purchase' => 1
                    ];
                    $request->merge($data);
                    
                    app(CartController::class)->buyCourse($request);
                    app(PayController::class)->savePaymentRecharge($payment->user_id,$payment->product_price,$payment->openpay_order_id,1, $payment->product_detail);
                    $payment->delete();
                }else if($payment->product_name == 'recharge_found'){
                    app(PayController::class)->saveOpcWallet($payment->user_id,$payment->product_price,4,$payment->product_detail);
                    app(PayController::class)->savePaymentRecharge($payment->user_id,$payment->product_price,$payment->openpay_order_id,1, "Recarga de Fondos");

                    $payment->delete();
                }
            }
        }
    }

    public function getOpenpayConditions(){
        return view('modalOpenpayConditions');
    }
}
