<?php

namespace App\Http\Controllers;

use Carbon\Carbon;
use App\Models\User;
use App\Models\Point;
use App\Models\Course;
use App\Models\Option;
use App\Models\Wallet;
use GuzzleHttp\Client;
use App\Helpers\Helper;
use App\Models\Payment;
use App\Models\Product;
use App\Models\Classified;
use App\Models\AccountType;
use Illuminate\Http\Request;
use App\Models\WalletMovements;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use App\Models\AccountTypePointsMoney;
use App\Http\Controllers\OptionController;
use App\Models\UnverifiedPayment;
use App\Http\Controllers\Api\CartController;

class PayController extends Controller
{
    private $client_http;
    private $client_id;
    private $secret;

    public function __construct()
    {
        $this->client_http = new Client([
            'base_uri' => 'https://api-m.sandbox.paypal.com'
        ]);

        $this->client_id = config('services.paypal.client_id');
        $this->secret = config('services.paypal.secret');
    }

    public function viewMembershipPay()
    {
        if (session()->missing('body')) {
            return redirect()->route('login-form')->withWarning("Proceda a registrarse");
        }

        $id_membership = session()->get("body")["id_account_type"];
        $info_membership = AccountType::where('id', $id_membership)->get()->first();
        $user_info = session()->get("body");
        $price_total = $info_membership->price + ($info_membership->price * ($info_membership->iva / 100));
        $info_membership->total =  sprintf('%.2f', $price_total);
        $info_membership->price = sprintf('%.2f', $info_membership->price);
        $data = array($info_membership, $user_info);
        return view('content.user-membreship.payMembership')->with('data', $data);
    }

    public function viewMembershipPayUpdate($membershipId)
    {
        $id_membership = $membershipId;
        $info_membership = AccountType::where('id', $id_membership)->get()->first();
        $user_info = auth()->user();
        $price_total = $info_membership->price + ($info_membership->price * ($info_membership->iva / 100));
        $info_membership->total =  sprintf('%.2f', $price_total);
        $info_membership->price = sprintf('%.2f', $info_membership->price);
        $data = array($info_membership, $user_info, $membershipId);
        return view('content.user-membreship.payMembershipUpdate')->with('data', $data);
    }

    public function viewRecompra() // paypal pagar opc
    {
        $product = Product::where('name', '=', 'opc')->get()->first();
        $user_info = auth()->user();
        $igv = $product->price * 0.18;
        $total = $igv + $product->price;
        $data = array($product, $user_info, $total, $igv);
        return view('content.user-membreship.payRecompra')->with('data', $data);
    }

    public function payOPC()
    {
        $ip = \Request::ip();
        $purchase_number =  Helper::generatePurchaseCode();
        $product = Product::where('name', '=', 'opc')->get()->first();
        $user = auth()->user();
        $igv = $product->price * 0.18;
        $total = $igv + $product->price;
        $opc_data = compact('user', 'total', 'igv', 'product', 'ip', 'purchase_number');
        session(['opc_data' => $opc_data]);
        return view('content.opc.payment', $opc_data);
    }

    public function payWallet(Request $request)
    {
        try {
            DB::beginTransaction();

            $user = auth()->user();
            $user_wallet_balance = app(CartController::class)->retrieveWalletBalanceUser($user->id);
            $product = Product::where('name', '=', 'opc')->get()->first();
            if (!$user_wallet_balance >= $product->price) {
                throw new \Exception('Not enough money in user wallet');
            }
            $payment = new Payment();
            $payment->user_id = $user->id;
            $payment->id_user_sponsor = $user->id_referrer_sponsor;

            $payment->amount = $product->price;
            $payment->operation_number = 5;
            $payment->id_payment_method = 5;
            $payment->save();

            $userUpdate = User::where('id', $user->id)->get()->first();
            if ($user->id_account_type == 5 || $user->id_account_type == 6) {
                $userPromotionDays = Carbon::createFromFormat('Y-m-d H:i:s', now());
            } else {
                $userPromotionDays = Carbon::createFromFormat('Y-m-d H:i:s', $user->expiration_date);
            }
            $userPromotionDays->addDays(30);
            $userUpdate->expiration_date = $userPromotionDays;
            $userUpdate->save();

            $id = $user->id;
            $fullName = $user->name;
            $membersip = $user->id_account_type;

            $classified_user = Classified::where('user_id', $id)->first();
            $save_position_branch = $classified_user->position; //almacena la posicion del nodo anterior con respecto al actual

            $aux = false;

            if ($membersip != 5 && $membersip != 6) { //membresia basica y guest no genera puntos
                $tmp_id = $classified_user->user_id;
                while ($aux == false) {
                    $user_data = Classified::where('user_id', $tmp_id)->first();
                    $aux = $user_data->user_above == 'top' ? true : false;
                    $user_status = User::find($tmp_id);
                    if ($user_status->active && $user_status->qualified && $user_status->membershipActive) {
                        Point::create([
                            'user_id' => $user->id,
                            'sponsor_id' => $user_data->user_id,
                            'points' => $product->points,
                            'side' => $save_position_branch,
                            'reason' => "OPC points, " . $fullName
                        ]);
                    } elseif ($classified_user->id_user_sponsor == $user_data->user_id) {
                        Point::create([
                            'user_id' => $user->id,
                            'sponsor_id' => $classified_user->id_user_sponsor,
                            'points' => $product->points,
                            'side' => $save_position_branch,
                            'reason' => "OPC points, " . $fullName
                        ]);
                    }
                    $save_position_branch = $user_data->position;
                    $tmp_id = $user_data->user_above;
                }
            }

            $this->saveOpcWallet($user->id, $product->price, 1, "");

            DB::commit();

            return response()->json(['success' => true]);
        } catch (\Throwable $th) {
            DB::rollBack();

            Log::error('Error al procesar el pago por billetera: ' . $th->getMessage());
            return response()->json(['error' => 'Error interno del servidor'], 500);
        }
    }

    public function savePaymentRecharge($userID, $price, $operationNumber, $paymentId, $detailPurchase)
    {
        try {
            DB::beginTransaction();

            $payment = new Payment();
            $payment->user_id = $userID;
            $payment->id_user_sponsor = $userID;
            $payment->amount = $price;
            $payment->operation_number = $operationNumber;
            $payment->id_payment_method = $paymentId;
            $payment->details = $detailPurchase;
            $payment->save();

            DB::commit();
        } catch (\Throwable $th) {
            DB::rollBack();
            Log::error('Ocurrio un error al realizar el registro', [$th->getMessage()]);
        }
    }

    public function saveOpcWallet($userID, $price, $reasonId, $nameCourse)
    {
        $amount = $price;
        $user = $userID;

        $myWallet = Wallet::where('user_id', $user)->first();

        $last_batch = Option::lastBatch();
        $last_batch = (int) $last_batch->value;

        try {
            DB::beginTransaction();
            $movement = new WalletMovements();
            $movement->wallet_id = $myWallet->id;
            $movement->amount = $amount;
            $movement->type = $reasonId == 4 ? 1 : 0;
            $movement->batch = $last_batch;
            $movement->status = 1;

            $movement->reason = ($reasonId == 1) ? 'Recompra OPC' : (($reasonId == 2) ? 'Actualización membresía' : (($reasonId == 3) ? 'Compra de curso ' . $nameCourse : 'Recarga de Fondos'));

            if ($movement->save()) {
                $response['status'] = 'ok';
            } else {
                $response['status']  = 'error';
            }

            DB::commit();

            echo json_encode($response);
        } catch (\Throwable $th) {
            DB::rollBack();
            throw $th;
        }
    }

    public function payMembershipUpdate(Request $request)
    {
        try {
            DB::beginTransaction();

            $membership_id = $request->membership_id;
            $user = auth()->user();

            $payment = new Payment();
            $payment->user_id = $user->id;
            $payment->id_user_sponsor = $user->id_referrer_sponsor;

            $account_type = AccountType::find($membership_id);
            $payment->amount = $account_type->price;
            $payment->operation_number = 5;
            $payment->id_payment_method = 5;
            $payment->save();

            if ($user->id_account_type == 5 || $user->id_account_type == 6) {
                $userRenewMembership = Carbon::createFromFormat('Y-m-d H:i:s', now());
            } else {
                $userRenewMembership = Carbon::createFromFormat('Y-m-d H:i:s', $user->expiration_membership_date);
            }
            $userRenewMembership->addDays(365);

            $userUpdate = User::where('id', $user->id)->get()->first();
            $userUpdate->id_account_type = $membership_id;
            $userUpdate->expiration_membership_date = $userRenewMembership;
            if ($user->id_account_type == 5 || $user->id_account_type == 6) {
                $userRenewOPC = Carbon::createFromFormat('Y-m-d H:i:s', now());
            } else {
                $userRenewOPC = Carbon::createFromFormat('Y-m-d H:i:s', $user->expiration_date);
            }
            $userRenewOPC->addDays(30);
            $userUpdate->expiration_date = $userRenewOPC;
            $userUpdate->update();

            $id = $user->id;
            $fullName = $user->name;
            $membersip = $user->id_account_type;

            $atm =  AccountTypePointsMoney::where('account_type_id', $membership_id)->first();
            $classified_user = Classified::where('user_id', $id)->first();
            $save_position_branch = $classified_user->position;

            $aux = false;

            if ($membership_id != 5 && $membership_id != 6) {
                $tmp_id = $classified_user->user_id;
                while ($aux == false) {
                    $user_data = Classified::where('user_id', $tmp_id)->first();
                    $aux = $user_data->user_above == 'top' ? true : false;
                    $user_status = User::find($tmp_id);
                    if ($user_status->active && $user_status->qualified && $user_status->membershipActive) {
                        Point::create([
                            'user_id' => $user->id,
                            'sponsor_id' => $user_data->user_id,
                            'points' => $atm->points,
                            'side' => $save_position_branch,
                            'reason' => "Membership buy, " . $fullName
                        ]);
                    } elseif ($classified_user->id_user_sponsor == $user_data->user_id) {
                        Point::create([
                            'user_id' => $user->id,
                            'sponsor_id' => $classified_user->id_user_sponsor,
                            'points' => $atm->points,
                            'side' => $save_position_branch,
                            'reason' => "Membership buy, " . $fullName
                        ]);
                    }
                    $save_position_branch = $user_data->position;
                    $tmp_id = $user_data->user_above;
                }

                //batch para el historial de la billetera segun corte binario
                $last_batch = Option::lastBatch();
                $last_batch = (int) $last_batch->value;

                //bono de efectivo rapido
                if ($membership_id != 5 && $membership_id != 6) { //membresia basica y guest no genera bono
                    if ($user->id_referrer_sponsor != 1) {
                        $id_account_type_sponsor = User::select('id_account_type')->where('id', $user->id_referrer_sponsor)->first();
                        $fast_cash_sponsor = AccountType::select('fast_cash_bonus')->where('id', $id_account_type_sponsor->id_account_type)->first();
                        $walletParentDirect  = Wallet::where('user_id', $user->id_referrer_sponsor)->first();
                        $movement = new WalletMovements();
                        $movement->wallet_id = $walletParentDirect->id;
                        $movement->amount = $account_type->price * ($fast_cash_sponsor->fast_cash_bonus / 100);
                        $movement->type = 1;
                        $movement->batch = $last_batch;
                        $movement->bonus_type_id = 1; // bono de efectivo rapido
                        $movement->reason = 'Bono de efectivo rápido de ' . $user->username;
                        $movement->save();
                    }
                }
            }

            //Actualiza el registro de la fecha de expiracion de su memebresia en la tabla ACCOUNT_TYPE_DETAIL
            $this->updateUserMembershipExpirationDate($user->id, $account_type->id);

            $this->saveOpcWallet($user->id, $account_type->price, 2, "");

            DB::commit();

            return response()->json(['success' => true]);
        } catch (\Throwable $th) {
            DB::rollBack();

            Log::error('Error al procesar el pago por billetera: ' . $th->getMessage());
            return response()->json(['error' => 'Error interno del servidor'], 500);
        }
    }

    public function openpayOPC()
    {
        $user = auth()->user();
        $product = Product::where('name', 'opc')
            ->first();
        $user_id = $user->id;
        $user_name = $user->name;
        $user_lastname = $user->last_name;
        $user_phone = $user->phone;
        $user_email = $user->email;
        $product_id = null;
        $product_name = "opc";
        $now = Carbon::now();
        $product_price = $product->price;
        $product_detail = "Recompra de OPC";
        $key_openpay = env("OPENPAY_SK_ENCODED");
        $id_openpay = env("OPENPAY_ID");

        return view('content.opc.openpay', compact('product_id', 'product_name', 'user_id', 'product_price', 'product_detail', 'user_name', 'user_lastname', 'user_phone', 'user_email', 'key_openpay', 'id_openpay'));
    }

    public function authorizeopc(Request $request)
    {
        $transaction_token = $request->transactionToken;

        $merchant_id = '456879853';
        $api = "https://apisandbox.vnforappstest.com/api.authorization/v3/authorization/ecommerce/$merchant_id}";

        $data = session()->get("opc_data");

        $purchase_number = session()->get("opc_data")["purchase_number"];
        $total = session()->get("opc_data")["total"];

        $purchase_data = array(
            "channel" => $request->channel,
            "captureType" => "manual",
            'countable' => 'true',
            "order" => array(
                "tokenId" => $transaction_token,
                "purchaseNumber" => $purchase_number,
                "amount" => $total,
                "currency" => "USD"
            ),
        );

        $access_token = NiubizController::createNiubizToken();

        return view('content.opc.invoice', compact('purchase_data', 'access_token', 'data', 'purchase_number'));
    }

    public function opcprocess(Request $request)
    {
        return $this->registerSuccessRecompra($request['order']['purchaseNumber']);
    }

    public function getAccessTokenPaypal()
    {
        $response = $this->client_http->request('POST', '/v1/oauth2/token', [
            'headers' => [
                'Accept' => 'application/json',
                'Content-Type' => 'application/x-www-form-urlencoded',
            ],
            'body' => 'grant_type=client_credentials',
            'auth' => [$this->client_id, $this->secret, 'basic']
        ]);

        $data = json_decode($response->getBody(), true);
        return $data["access_token"];
    }

    public function registerSuccessPayment($order_id)
    {
        app(UserController::class)->Create($order_id);
    }

    public function registerSuccessPaymentUpdate($order_id, $membership_id)
    {
        app(UserController::class)->membershipUpdate($order_id, $membership_id);
    }

    public function registerSuccessRecompra($order_id)
    {
        app(UserController::class)->recompraUpdate($order_id);
    }

    public function process($order_id)
    {
        $access_token = $this->getAccessTokenPaypal();
        $response = $this->client_http->request('GET', '/v2/checkout/orders/' . $order_id, [
            'headers' => [
                'Accept' => 'application/json',
                'Authorization' => "Bearer $access_token",
            ],
        ]);

        $data = json_decode($response->getBody(), true);

        if ($data["status"] == 'APPROVED') {
            $this->registerSuccessPayment($order_id);
            return [
                'success' => true,
                'data' => $data
            ];
        }
        return [
            'error' => false
        ];
    }

    public function processUpdate($order_id, $membership_id)
    {
        $access_token = $this->getAccessTokenPaypal();
        $response = $this->client_http->request('GET', '/v2/checkout/orders/' . $order_id, [
            'headers' => [
                'Accept' => 'application/json',
                'Authorization' => "Bearer $access_token",
            ],
        ]);

        $data = json_decode($response->getBody(), true);

        if ($data["status"] == 'APPROVED') {
            $this->registerSuccessPaymentUpdate($order_id, $membership_id);
            return [
                'success' => true,
                'data' => $data
            ];
        }
        return [
            'error' => false
        ];
    }

    public function processRecompra($order_id)
    {
        $access_token = $this->getAccessTokenPaypal();
        $response = $this->client_http->request('GET', '/v2/checkout/orders/' . $order_id, [
            'headers' => [
                'Accept' => 'application/json',
                'Authorization' => "Bearer $access_token",
            ],
        ]);

        $data = json_decode($response->getBody(), true);

        if ($data["status"] == 'APPROVED') {
            $this->registerSuccessRecompra($order_id);
            return [
                'success' => true,
                'data' => $data
            ];
        }
        return [
            'error' => false
        ];
    }

    public function openpayMembership($id)
    {
        $user = auth()->user();
        $account = AccountType::where('id', $id)
            ->select('price', 'account')
            ->first();
        $user_id = $user->id;
        $user_name = $user->name;
        $user_lastname = $user->last_name;
        $user_phone = $user->phone;
        $user_email = $user->email;
        $product_id = $id;
        $product_name = "membership";
        $product_price = $account->price;
        $product_detail = "Recompra de membresía " . $account->account;
        $key_openpay = env("OPENPAY_SK_ENCODED");
        $id_openpay = env("OPENPAY_ID");

        return view('content.opc.openpay', compact('product_id', 'product_name', 'user_id', 'product_price', 'product_detail', 'user_name', 'user_lastname', 'user_phone', 'user_email', 'key_openpay', 'id_openpay'));
    }

    public function openpayRecharge($mount, $typepayment)
    {
        $user = auth()->user();

        $product_id = $typepayment;
        $product_name = "recharge_found";
        $user_id = $user->id;
        $product_price = $mount;
        $product_detail = "Recargar Fondos Billtera";
        $user_name = $user->name;
        $user_lastname = $user->last_name;
        $user_phone = $user->phone;
        $user_email = $user->email;

        $key_openpay = env("OPENPAY_SK_ENCODED");
        $id_openpay = env("OPENPAY_ID");

        return view('content.opc.openpay', compact('product_id', 'product_name', 'user_id', 'product_price', 'product_detail', 'user_name', 'user_lastname', 'user_phone', 'user_email', 'key_openpay', 'id_openpay'));
    }

    public function rechargeOpenpayProcess(Request $request)
    {
        $openpay = \Openpay\Data\Openpay::getInstance(env("OPENPAY_ID"), env("OPENPAY_SK_DECODED"), 'PE');
        \Openpay\Data\Openpay::setProductionMode(false);
        $customer = $request->customer;
        $order_id = 'promolider2024-' . app(OptionController::class)->openpayOrder();
        $chargeRequest = array(
            'order_id' => $order_id,
            'method' => 'card',
            'currency' => 'USD',
            'amount' => strval($request->amount),
            'description' => $request->description,
            'customer' => $customer,
            'send_email' => false,
            'confirm' => false,
            'redirect_url' => env('APP_URL') . 'login'
        );

        $charge = $openpay->charges->create($chargeRequest);
        $charge_data = [
            'payment_url' => $charge->payment_method->url,
            "charge_id" => $charge->id
        ];


        return response()->json($charge_data);
    }

    public function registerOpenpayProcess(Request $request)
    {
        $openpay = \Openpay\Data\Openpay::getInstance(env("OPENPAY_ID"), env("OPENPAY_SK_DECODED"), 'PE');
        \Openpay\Data\Openpay::setProductionMode(false);
        $customer = $request->customer;
        $order_id = 'promolider2024-' . app(OptionController::class)->openpayOrder();
        $chargeRequest = array(
            'order_id' => $order_id,
            'method' => 'card',
            'currency' => 'USD',
            'amount' => strval($request->amount),
            'description' => $request->description,
            'customer' => $customer,
            'send_email' => false,
            'confirm' => false,
            'redirect_url' => env('APP_URL') . 'login'
        );

        $charge = $openpay->charges->create($chargeRequest);
        $charge_data = [
            'payment_url' => $charge->payment_method->url,
            "charge_id" => $charge->id
        ];

        return response()->json($charge_data);
    }

    public function openpayCourse(Request $request)
    {
        $user = auth()->user();
        $course = Course::where('id', $request->course_id)->first();
        $user_id = $user->id;
        $user_name = $user->name;
        $user_lastname = $user->last_name;
        $user_phone = $user->phone;
        $user_email = $user->email;
        $product_id = $request->course_id;
        $product_name = "course";

        $account_type = AccountType::find(auth()->user()->id_account_type);
        $price_with_discount = round($course->price - (($course->price * $account_type->disc_purchases_course) / 100), 2);
        $product_price = $price_with_discount;
        $product_detail = "Compra de curso: " . $course->title;
        $key_openpay = env("OPENPAY_SK_DECODED");
        $id_openpay = env("OPENPAY_ID");

        $openpay = \Openpay\Data\Openpay::getInstance($id_openpay, $key_openpay, 'PE');
        \Openpay\Data\Openpay::setProductionMode(false);
        $customer = array(
            'name' => $user_name,
            'last_name' => $user_lastname,
            'phone_number' => $user_phone,
            'email' => $user_email
        );
        $order_id = 'promolider2024-' . app(OptionController::class)->openpayOrder();
        $chargeRequest = array(
            'order_id' => $order_id,
            'method' => 'card',
            'currency' => 'USD',
            'amount' => strval($product_price),
            'description' => $product_detail,
            'customer' => $customer,
            'send_email' => false,
            'confirm' => false,
            'redirect_url' => env('FRONTEND_APP_URL') . 'suscription-user'
        );

        $charge = $openpay->charges->create($chargeRequest);
        $charge_data = [
            'payment_url' => $charge->payment_method->url
        ];

        $payment = new UnverifiedPayment();
        $payment->user_id = $user_id;
        $payment->openpay_order_id = $charge->id;
        $payment->product_id = $product_id;
        $payment->product_detail = $product_detail;
        $payment->product_price = $product_price;
        $payment->product_name = $product_name;
        $payment->save();
        return response()->json($charge_data);
    }
}
