<?php

namespace App\Http\Controllers\MC;

use App\Helpers\Helper;
use App\Http\Controllers\Controller;
use App\Models\MasterClassNotification;
use App\Models\MasterClassParticipant;
use App\Models\MasterClassVideo;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Storage;
use App\Helpers\CreateNotification;
use App\Notifications\userSubscribeToMasterClass;

class ParticipantController extends Controller
{
    public function subscribe(Request $request)
    {
        try {
            DB::beginTransaction();
            $participant = new MasterClassParticipant();
            $participant->master_class_id = $request->masterClassId;
            $participant->fullname = $request->fullname;
            $participant->email = $request->email;
            $participant->phone = $request->phone;
            $participant->save();

            $receiver = MasterClassVideo::where('id', $request->masterClassId)->first()->user_id;
            $masterClassTitle = MasterClassVideo::where('id', $request->masterClassId)->first()->title;
            $request->request->add([
                'receiver' => $receiver,
                'title' => "$request->fullname se ha registrado al master class de $masterClassTitle",
            ]);
            $saveNotification = CreateNotification::saveNotification($request);

            $user = User::where('id', $receiver)->first();
            // $user->notify(new userSubscribeToMasterClass('Hello World'));

            if ($saveNotification) {
                DB::commit();
                return response()->json(['message' => 'Te has registrado al master class correctamente'], 200);
            }
        } catch (\Throwable $th) {
            return response()->json([
                'status' => 'error',
                'message' => $th->getMessage(),
            ], 500);
        }
    }
    public function list()
    {
        $userId = auth()->user()->id;
        $masterClassIds = MasterClassVideo::where('user_id', $userId)->pluck('id');
        $participants = MasterClassParticipant::whereIn('master_class_id', $masterClassIds)->with(['masterClass'])->get();
        // // $participants = MasterClassVideo::select('id', 'course_id', 'title', 'created_at', 'start_at')
        // ->with(['course:id,title'])
        // ->where('user_id', $userId)->get();
        return response()->json($participants, 200);
    }
}
