<?php

namespace App\Http\Controllers;

use App\Models\Clas;
use App\Models\CourseConfiguration;
use App\Models\Module;
use App\Models\PurchasedCourse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\CertificatesController;
use App\Models\Course;
use App\Models\UserCertificate;
use App\Models\Exam as ModelsExam;
use App\Models\User;
use App\Models\UserExamHeader;

class CourseConfigurationController extends Controller
{
    public function store(Request $request)
    {
        try {
            DB::beginTransaction();
            $type = $this->determineType($request->type);
            $data = $this->buildArray($type, $request->course, $request->module, $request->lesson, $request->type_certificate, $request->certificate_price);
            $configuration = new CourseConfiguration();
            $configuration->course_id = $request->course;
            $configuration->validated_by = $type;
            $configuration->data = $data;
            $configuration->type_certificate = $request->type_certificate;
            $configuration->condition_to_certificate = $request->condition_to_certificate;
            $configuration->customized_certificate = $request->customized_certificate;
            $configuration->save();
            DB::commit();
        } catch (\Throwable $th) {
            DB::rollBack();
            throw $th;
        }
    }

    public function determineType($number)
    {
        switch ($number) {
            case '1':
                $str = 'course';
                break;
            case '2':
                $str = 'module';
                break;
            case '3':
                $str = 'lesson';
                break;
            default:
                $str = '';
                break;
        }
        return $str;
    }

    public function buildArray($type, $course_id, $module_id = null, $lesson_id = null, $type_certificate, $certificate_price)
    {
        if ($type_certificate == 1) {
            $certificate_price = 0;
        }

        switch ($type) {
            case 'course':
                $json = array(
                    'course' => $course_id,
                    'certificate_price' => $certificate_price

                );
                break;
            case 'module':
                $json = array(
                    'course' => $course_id,
                    'module' => $module_id,
                    'certificate_price' => $certificate_price
                );
                break;
            case 'lesson':
                $json = array(
                    'course' => $course_id,
                    'module' => $module_id,
                    'lesson' => $lesson_id,
                    'certificate_price' => $certificate_price
                );
                break;
            default:
                $json = '';
                break;
        }
        return $json;
    }

    public function isReadyToClaimCertificate($id)
    {
        $course_id = $id;
        $lesson_seen = $this->getLessonSeen($course_id);
        $course_config = CourseConfiguration::where('course_id', $course_id)->exists();
        // return $lesson_seen;
        if ($course_config) {
            $conf = CourseConfiguration::where('course_id', $course_id)->first();
            if ($conf->condition_to_certificate != 1) {
                switch ($conf->validated_by) {
                    case 'course':
                        # Valida si todas las clases fueron vistas
                        $boolean = $this->validateCourseSeen($lesson_seen, $course_id);
                        break;
                    case 'module':
                        # Valida si todas las clases anteriores y las del modulo configurado ha sido vista
                        $boolean = $this->validateModuleSeen($lesson_seen, $conf);
                        break;
                    case 'lesson':
                        # Valida si todas las clases anteriores y la clase configurada ha sido vista
                        $boolean = $this->validateLessonSeen($lesson_seen, $conf);
                        break;
                    default:
                        break;
                }
            }

            if ($conf->condition_to_certificate != 0) {
                $boolean2 = $this->validateExams($course_id);
            }
            if ($conf->condition_to_certificate == 0) {
                $evaluate_condition = $boolean;
            } else if ($conf->condition_to_certificate == 1) {
                $evaluate_condition = $boolean2;
            } else if ($conf->condition_to_certificate == 2) {
                $evaluate_condition = $boolean && $boolean2;
            }
            $user = User::findOrFail(auth()->user()->id);
            if ($evaluate_condition) {
                $Certificate = UserCertificate::select('id')->where(['id_user' => $user->id, 'id_course' => $course_id])->get();
                //validar si ya se creo el certificado
                if (count($Certificate) == 0) {
                    $certificate = app(CertificatesController::class)->createCertificate($user, $course_id);
                    return $certificate;
                }
                $purchased_course = PurchasedCourse::where('course_id', $course_id)
                    ->where('user_id', $user->id)
                    ->first();
                if ($purchased_course->completed_date == null) {
                    $purchased_course->completed_course = 1;
                    $purchased_course->completed_date = now();
                    $purchased_course->update();
                }
            }
        } else {
            $evaluate_condition = false;
        }
        echo json_encode($evaluate_condition);
    }

    public function validateExams($course_id)
    {
        $classes = Module::join('class', 'modules.id', '=', 'class.id_modules')
            ->join('courses', 'modules.id_courses', '=', 'courses.id')
            ->where('courses.id', $course_id)
            ->select('class.id as class_id', 'class.name', 'class.slug')
            ->get();
        $modules = Course::join('modules', 'courses.id', '=', 'modules.id_courses')
            ->where('courses.id', $course_id)
            ->select('modules.id as module_id', 'modules.name', 'modules.name as slug')
            ->get();
        $approve_condition = null;
        foreach ($classes as $class) {
            if (ModelsExam::where(['lesson_id' => $class->class_id, 'status' => 1])->exists()) {
                $exam_id = ModelsExam::where('lesson_id', $class->class_id)->pluck('id');
                if (UserExamHeader::where([
                    'exam_id' => $exam_id[0],
                    'condition' => 'Approved',
                    'user_id' => auth()->user()->id
                ])->exists()) {
                    $approve_condition = true;
                } else {
                    return false;
                }
            }
        }

        foreach ($modules as $module) {
            if (ModelsExam::where(['module_id' => $module->module_id, 'status' => 1])->exists()) {
                $exam_id = ModelsExam::where('module_id', $module->module_id)->pluck('id');
                if (UserExamHeader::where([
                    'exam_id' => $exam_id[0],
                    'condition' => 'Approved',
                    'user_id' => auth()->user()->id
                ])->exists()) {
                    $approve_condition = true;
                } else {
                    return false;
                }
            }
        }

        if (ModelsExam::where(['course_id' => $course_id, 'status' => 1])->exists()) {
            $exam_id = ModelsExam::where('course_id', $course_id)->pluck('id');
            if (UserExamHeader::where([
                'exam_id' => $exam_id[0],
                'condition' => 'Approved',
                'user_id' => auth()->user()->id
            ])->exists()) {
                $approve_condition = true;
            } else {
                return false;
            }
        }
        return $approve_condition;;
    }

    //Validar si las  clases anteriores al modulo actual y de modulos anteriores han sido vistas
    public function validateLessonSeen($lesson_seen, $course_config)
    {
        $course_id =  $course_config->data['course'];
        $module_id =  $course_config->data['module'];
        $lesson_id =  $course_config->data['lesson'];
        $extra = $this->getLessonsFromCurrentModule($lesson_id,  $module_id);
        $modules = Module::where('id_courses', $course_id)->pluck('id')->toArray();
        $modules_ids_filtered = array_filter($modules, fn($xd) => $xd < $module_id);
        $lessons = $this->getRequiredLessonsIds($modules_ids_filtered);
        $full_lessons = array_merge($lessons, $extra);
        return $this->isAllLessonsSeen($lesson_seen, $full_lessons);
    }

    public function validateModuleSeen($lesson_seen, $course_config)
    {
        $course_id =  $course_config->data['course'];
        $module_id =  $course_config->data['module'];
        $modules = Module::where('id_courses', $course_id)->pluck('id')->toArray();
        $modules_ids_filtered = $this->getRequiredModulesIds($modules, $module_id);
        $lessons = $this->getRequiredLessonsIds($modules_ids_filtered);
        return $this->isAllLessonsSeen($lesson_seen, $lessons);
    }

    public function getRequiredLessonsIds($modules)
    {
        $lessons_ids = [];
        $data = [];

        foreach ($modules as $module_id) {
            $id = Clas::where('id_modules', $module_id)->pluck('id')->toArray();
            array_push($lessons_ids, $id);
        }

        # Combinar los ids de clase de las colecciones
        foreach ($lessons_ids as $record) {
            $data = array_merge($data, $record);
        }
        return $data;
    }

    public function getRequiredModulesIds($modules, $limit)
    {
        return array_filter($modules, fn($module_id) => $module_id <= $limit);
    }

    public function isAllLessonsSeen($lesson_seen, $classes)
    {
        $value = false;
        foreach ($classes as $class) {
            if (array_key_exists($class, $lesson_seen)) {
                $value = true;
            } else {
                $value = false;
                break;
            }
        }
        return $value;
    }

    public function getLessonsFromCurrentModule($lesson_id, $module_id)
    {
        //error: aqui dará error al implementar la funcionalidad de reordenamiento de clases
        $extra_lessons = Clas::where('id_modules',  $module_id)->pluck('id')->toArray();
        return array_filter($extra_lessons, fn($xd) => $xd <= $lesson_id);
    }

    public function validateCourseSeen($lesson_seen, $course_id)
    {
        $classes = Module::join('class', 'modules.id', '=', 'class.id_modules')
            ->where('modules.id_courses', $course_id)
            ->pluck('class.id');
        return $this->isAllLessonsSeen($lesson_seen, $classes);
    }

    public function fillArray($data)
    {
        $array = [];
        foreach ($data as $item) {
            array_push($array, $item[1]);
        }
        return $array;
    }

    public function getLessonSeen($course_id)
    {
        $lesson_seen = PurchasedCourse::where('course_id', '=', $course_id)
            ->where('user_id', auth()->user()->id)
            ->pluck('classes_status');
        $lesson_seen = json_decode($lesson_seen[0], TRUE);
        return $lesson_seen;
    }

    public function getLessonSeenFiltered($array, $include)
    {
        $data = [];
        foreach ($array as $item) {
            if (in_array($item[0], $include)) {
                array_push($data, $item);
            }
        }
        return $data;
    }

    public function getCertificateConfiguration(Request $request)
    {
        //correccion
        $courseConfiguration = CourseConfiguration::join('courses', 'course_configuration.course_id', '=', 'courses.id')
            ->where('course_id', $request->course_id)
            ->select('course_configuration.*', 'courses.title', 'courses.url_portada')
            ->first();
        $courseConfiguration->url_portada = config('global_variables.storage_domain') . '/' . $courseConfiguration->url_portada;
        return $courseConfiguration;
    }
}
