<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Providers\RouteServiceProvider;
use App\Models\User;
use Illuminate\Foundation\Auth\RegistersUsers;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;

class RegisterController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Register Controller
    |--------------------------------------------------------------------------
    |
    | This controller handles the registration of new users as well as their
    | validation and creation. By default this controller uses a trait to
    | provide this functionality without requiring any additional code.
    |
    */

    use RegistersUsers;

    /**
     * Where to redirect users after registration.
     *
     * @var string
     */
    protected $redirectTo = RouteServiceProvider::HOME;

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        // $this->middleware('guest');
    }

    /**
     * Get a validator for an incoming registration request.
     *
     * @param  array  $data
     * @return \Illuminate\Contracts\Validation\Validator
     */
    protected function validator(array $data)
    {
        return Validator::make($data, [
            'name' => ['required', 'string', 'max:255'],
            'email' => ['required', 'string', 'email', 'max:255', 'unique:users'],
            'password' => ['required', 'string', 'min:8', 'confirmed'],
        ]);
    }

    /**
     * Create a new user instance after a valid registration.
     *
     * @param  array  $data
     * @return \App\Models\User
     */
    protected function create(array $data)
    {
        return User::create([
            'name' => $data['name'],
            'email' => $data['email'],
            'password' => Hash::make($data['password']),
        ]);
    }

    // Register - deshabilitado 
    // public function showRegistrationForm()
    // {
    //     $pageConfigs = ['blankPage' => true];

    //     return view('/auth/register11', [
    //     'pageConfigs' => $pageConfigs
    //     ]);
    // }
    public function verifyEmail(Request $request){
        if(User::where('email',$request->email)->exists()){
            return response()->json(true);
    }else{
        return response()->json(false);
    }
    }
    public function verifyUsername(Request $request){
        if(User::where('username',$request->username)->exists()){
            return response()->json(true);
    }else{
        return response()->json(false);
    }
    }


    public function verifyDocument(Request $request){
        if(User::where('id_document_type',$request->documentType)->where('nro_document',$request->documentNumber)->exists()){
            return response()->json(true);
    }else{
        return response()->json(false);
    }
    }
}
