<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use App\Models\Product;

class OPCController extends Controller
{
    public function index()
    {
        try {
            $opc = Product::where('name','opc')->get();

            return response()->json([
                'status' => true,
                'data' => $opc,
                'message' => 'Data recuperada con exito',
            ], 200);

        } catch (\Throwable $th) {
            return response()->json([
                'status' => false,
                'message' => 'Ocurrio un error ' . $th->getMessage(),
            ], 500);
        }
    }

    public function store(Request $request)
    {
        try {
                       
            $opc =Product::where('name','opc')->first();

            $opc->descripcion = $request->input('descripcion');
            $opc->price = $request->input('price');
            $opc->promotion_prince = $request->input('promotion_prince');
            $opc->commission = $request->input('commission');
            $opc->points = $request->input('points');
            
            $opc->save();
            
            return response()->json([
                'status' => 'success',
                'message' => 'Actualización exitosa.',
                'data' => $opc
            ], Response::HTTP_OK);
            
        } catch (\Throwable $th) {
            return response()->json([
                'status' => 'error',
                'message' => 'Error al actualizar.',
                'error' => $th->getMessage()
            ], Response::HTTP_INTERNAL_SERVER_ERROR);
        }
    }
}
