@isset($pageConfigs)
    {!! Helper::updatePageConfig($pageConfigs) !!}
@endisset

<!DOCTYPE html>
{{-- {!! Helper::applClasses() !!} --}}
@php
$configData = Helper::applClasses();
$get_auth_config = Helper::getAuthConfig();
@endphp

<html lang="@if (session()->has('locale')) {{ session()->get('locale') }}@else{{ $configData['defaultLanguage'] }} @endif"
    data-textdirection="{{ env('MIX_CONTENT_DIRECTION') === 'rtl' ? 'rtl' : 'ltr' }}"
    class="{{ $configData['theme'] === 'light' ? '' : $configData['layoutTheme'] }}">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width,initial-scale=1.0">
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>@yield('title') - Promolider</title>
    <link rel="shortcut icon" type="image/x-icon" href="{{ asset('images/logo/favicon_navidad (1).ico') }}">
    <link href="https://fonts.googleapis.com/css2?family=Montserrat:ital,wght@0,300;0,400;0,500;0,600;1,400;1,500;1,600"
        rel="stylesheet">
    <link rel="stylesheet" href="{{asset('css/openpay.css')}}">
    {{-- Include core + vendor Styles --}}
    @include('panels/styles')

</head>
<body>
    @yield('content')

    <!-- seccion para los scrips -->
    <script src="{{ asset(mix('js/app.js')) }}"></script>
    @yield('page-script')
</body>
<script type="text/script">
    window.Laravel = {
        csrfToken: "{{ csrf_token() }}",
        jsPermissions: {!! auth()->check()
    ? auth()->user()->jsPermissions()
    : null !!}
    }
</script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>