<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class SponsorLink extends Model
{
    use HasFactory;
    protected $guarded = [];
    protected $table = "sponsor_link";
    protected $fillable = ['url','fecha_inicio','fecha_fin','estado','user_id'];

    //Relacion uno a muchos inversa
    public function user(){
        return $this->belongsTo(User::class);
    }
}
