<?php

namespace App\Http\Controllers\Api;

use App\Events\MessageSentEvent;
use App\Models\User;
use App\Models\Message;
use App\Traits\ResponseFormat;
use App\Http\Controllers\Controller;
use App\Models\Course;
use App\Models\PurchasedCourse;
use Illuminate\Http\Request;

class MessageController extends Controller
{
    use ResponseFormat;

    /**
     * Show message of users
     * @param $email {string} -> email to user
     * @return \Illuminate\Http\Response
     */
    public function show($email)
    {
        $idUser = auth()->user()->id;
        if ($idUser2 = User::where('email', $email)->first()) {
            $idUser2 = $idUser2->id;
            $data = Message::select('users.name', 'messages.message', 'messages.created_at')
                ->join('users', 'users.id', '=', 'messages.transmitter_id')
                ->where([
                    ['messages.transmitter_id', '=', $idUser],
                    ['messages.receiver_id', '=', $idUser2]
                ])
                ->orWhere([
                    ['messages.transmitter_id', '=', $idUser2],
                    ['messages.receiver_id', '=', $idUser]
                ])
                ->orderBy('messages.created_at', 'ASC')
                ->get();
            if (isset($data[0])) {
                return $this->responseOk('', $data);
            } else {
                return ["error" => "No conversations"];
            }
        } else {
            return ["error" => "No conversations"];
        }
    }

    /**
     * Show user's list with messages
     * @return \Illuminate\Http\Response
     */
    public function list()
    {
        if ($msj = Message::MessageSelect()->MessageOrder()) {
            $json = [];
            foreach ($msj as $key => $value) {
                if (count($json) >= 5) {
                    break;
                } else {
                    $json[] = $msj[$key]->first();
                }
            }
            return $this->responseOk('', $json);
        } else {
            return ['error' => "no conversations"];
        }
    }

    /**
     * Store new messages of users
     * @param $request {Request}
     *   ->$id -> id of the user receive
     *   ->$message -> the message
     * @return \Illuminate\Http\Response
     */
    public function addMessage(Request $request)
    {
        $msj = new Message();
        $msj->transmitter_id = auth()->user()->id;
        $msj->receiver_id = $request->receiver_id;
        $msj->message = $request->message;
        $msj->save();
        $user = auth()->user()->id;

        if ($user > $msj->receiver_id) {
            $chatroom = $msj->receiver_id . $user;
        } else {
            $chatroom = $user . $msj->receiver_id;
        }


        broadcast(new MessageSentEvent($msj, $chatroom));

        return $this->responseOk('', 'message success');
    }

    /**
     * Show all messages
     * @return \Illuminate\Http\Response
     */
    public function listAll()
    {
        if ($msj = Message::MessageSelect()->MessageOrder()) {
            $json = [];
            foreach ($msj as $key => $value) {
                $json[] = $msj[$key]->first();
            }
            return $this->responseOk('', $json);
        } else {
            return ['error' => "no conversations"];
        }
    }

    public function listContacts($id)
    {
        $transmitter_collection = Message::where('transmitter_id', $id)->pluck('receiver_id')->toArray();
        $receiver_collection = Message::where('receiver_id', $id)->pluck('transmitter_id')->toArray();

        $merged = array_unique(array_merge($transmitter_collection, $receiver_collection));

        $user_contacts = User::whereIn('id', array_unique($merged))->whereNotIn('id', array($id))->pluck('id')->toArray();


        $data = [];

        foreach ($user_contacts as $user_id) {
            $contact = User::where('id', $user_id)->get()->first();

            $message_from_contact = Message::where(['receiver_id' => $id, 'transmitter_id' => $user_id])->exists();
            $message_from_me = Message::where(['receiver_id' => $user_id, 'transmitter_id' => $id])->exists();

            // Determine which was the last message
            if ($message_from_contact == true && $message_from_me == true) {
                $from_contact = Message::where(['receiver_id' => $id, 'transmitter_id' => $user_id])->latest('created_at')->get()->first()->created_at;
                $from_me =  Message::where(['receiver_id' => $user_id, 'transmitter_id' => $id])->latest('created_at')->get()->first()->created_at;

                if ($from_contact->gt($from_me)) {
                    $message = Message::where(['receiver_id' => $user_id, 'transmitter_id' => $id])->latest('created_at')->get()->first();
                } else {
                    $message = Message::where(['receiver_id' => $id, 'transmitter_id' => $user_id])->latest('created_at')->get()->first();
                }
            } elseif ($message_from_contact == true) {
                $message = Message::where(['receiver_id' => $id, 'transmitter_id' => $user_id])->latest('created_at')->get()->first();
            } else {
                $message = Message::where(['receiver_id' => $user_id, 'transmitter_id' => $id])->latest('created_at')->get()->first();
            }

            $data[] = array(
                'id'        => $contact->id,
                'name'     => $contact->name,
                'photo' => $contact->photo,
                'lastname'     => $contact->last_name,
                'last_message'     => $message->message,
                'time'     => $message->created_at
            );
        }

        return $data;
    }

    public function listNewContacts($id)
    {
        $transmitter_collection = PurchasedCourse::join('courses', 'courses.id', '=', 'purchased_courses.course_id')->where('purchased_courses.user_id', $id)->distinct()->pluck('courses.user_id')->toArray();
        $merged = array_unique($transmitter_collection);
        $user_contacts = User::whereIn('id', array_unique($merged))->whereNotIn('id', array($id))->pluck('id')->toArray();


        $data = [];

        foreach ($user_contacts as $user_id) {
            $contact = User::where('id', $user_id)->get()->first();
            $first = Message::where('transmitter_id', $user_id)->where('receiver_id', $id)->get()->first();
            $second = Message::where('receiver_id', $user_id)->where('transmitter_id', $id)->get()->first();

            if ($first == null && $second == null) {
                $data[] = array(
                    'id'        => $contact->id,
                    'name'     => $contact->name,
                    'photo' => $contact->photo,
                    'lastname'     => $contact->last_name,
                );
            }
        }

        return $data;
    }

    public function sendNewMessage(Request $request)
    {
        $message1 = new Message();
        $message1->transmitter_id = $request->id;
        $message1->receiver_id = $request->id2;
        $message1->message = 'Hola';
        $message1->save();
    }

    public function getContent(Request $request)
    {
        // transmitter_id user of login
        // receiver_id other user 

        $messages_for_me = Message::where(['transmitter_id' => $request->transmitter_id,  'receiver_id' => $request->receiver_id])->exists();
        $messages_send_by_me = Message::where(['transmitter_id' => $request->receiver_id,  'receiver_id' => $request->transmitter_id])->exists();


        if ($messages_for_me == true && $messages_send_by_me == true) {

            $messages1 =  Message::where(['transmitter_id' => $request->transmitter_id,  'receiver_id' => $request->receiver_id])->get();
            $messages2 =  Message::where(['transmitter_id' => $request->receiver_id,  'receiver_id' => $request->transmitter_id])->get();

            $merged = collect($messages1)->merge($messages2)->sortBy('created_at')->values();
            $messages = $merged->all();
        } elseif ($messages_for_me == true) {
            $messages =  Message::where(['transmitter_id' => $request->transmitter_id,  'receiver_id' => $request->receiver_id])->orderBy('created_at', 'desc')->take(5)->get();
        } else {
            $messages =  Message::where(['transmitter_id' => $request->receiver_id,  'receiver_id' => $request->transmitter_id])->orderBy('created_at', 'desc')->take(5)->get();
        }
        return $messages;
    }
}
